package editor;

import game.CustomImageDataII;
import game.IntRect;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.image.ImageObserver;
import java.io.BufferedWriter;
import java.io.File;

public class RogueBlockScreenObject extends ScreenObject  implements CloneableScreenObject{
	
	
	private boolean shouldBePassthru;
	private RogueBlockScreenPaletteObject paletteObject;
	private IntRect clickRect;
	
	private boolean isSelected = false;
	
	
	public RogueBlockScreenObject(int x, int y, int width, int height, RogueBlockScreenPaletteObject thePaletteObject, boolean passThru, IntRect theClickRect) {
		
		shouldBePassthru = passThru;
		
		paletteObject = thePaletteObject;
		
		clickRect = new IntRect(x - width/2, y - height/2, width, height);
		
//		System.out.println("new rogue block; x: " + x + ", y: " + y);
	}
	
	
	
	
	@Override
	public void draw(Graphics g) {
		
		paletteObject.getImage().drawObjectFromUpperLeftCorner(g, clickRect.getMinX(), clickRect.getMinY());
		
		if(isSelected()) {
			drawSelectionOverObject(g);
		}
		
	}

	@Override
	public IntRect getClickRect() {
		return clickRect;
	}

	@Override
	public void setSelected(boolean is) {
		isSelected = is;
	}

	@Override
	public boolean isSelected() {
		return isSelected;
	}




	@Override
	public void setClickRect(IntRect newRect) {
		clickRect = newRect;
	}




	public boolean isShouldBePassthru() {
		return shouldBePassthru;
	}




	public void setShouldBePassthru(boolean shouldBePassthru) {
		this.shouldBePassthru = shouldBePassthru;
	}
	
	public PaletteObject getPaletteObject() {
		return paletteObject;
	}
	
	
	public void writeOutToFile(BufferedWriter out) throws Exception{
		
		out.write("block:");
		out.newLine();
		
		Point centerPoint = clickRect.getCenter();
		
		out.write("x:");
		out.write(Integer.toString(centerPoint.x));
		out.newLine();
		
		out.write("y:");
		out.write(Integer.toString(centerPoint.y));
		out.newLine();
		
		out.write("width:");
		out.write(Integer.toString(this.getClickRect().width()));
		out.newLine();
		
		out.write("height:");
		out.write(Integer.toString(this.getClickRect().height()));
		out.newLine();
		
		out.write("graphic:");
		out.write(this.paletteObject.getImage().getFileName());
		out.newLine();
		
		if(this.paletteObject.shouldBePassThru()) {
			out.write("passThru");
		} else {
			out.write("solid");
		}
		out.newLine();
		
		out.write("transparent:");
		out.write(CustomAnimationPanel.convertColorToString(paletteObject.getImage().getTransparentColor()));
		out.newLine();
		
		
		
		out.write("/block");
		out.newLine();
		
		out.newLine();
	}
	
	
	public RogueBlockScreenObject clone(ImageObserver io) {
		
		Point centerPoint = clickRect.getCenter();
		
		RogueBlockScreenObject returnValue = new RogueBlockScreenObject(centerPoint.x, centerPoint.y, clickRect.width(), clickRect.height(), this.paletteObject, this.shouldBePassthru, this.clickRect);
		
		return returnValue;
		
		
	}
	
	@Override
	public int getLayer() {
		
		return 7;
	}
	
}
